import math
import random
import time

import numpy as np

# OWA for observations on competitive ratio
def OLSFake(
		T: int,
		L: int,
		K: int,
		gamma: float,
		consumptionArray: np.ndarray,
		valueArray: np.ndarray,
		granularity: float
) -> [float, float] :
	theta = 0
	W = 0
	h = np.array([0 for w in range(int(1/granularity)+1)])
	accumulatedReward = 0
	averageRunTime = 0
	for t in range(T):
		startTime = time.time()
		level = L
		if t==0:
			process = True
			dice = random.random()
			level = math.floor(dice/gamma)
			if level>L-1:
				process = False
		else:
			process = False
			if W <= theta and (K-W)>=1:
				process = True
				dice = random.random()
				level = min(math.floor(dice/(1/L)),L-1)

		if process:
			e = sample_eList(L,consumptionArray, t,level)
			W = W+e
			accumulatedReward+=valueArray[level,t]

		h = update_hList(
			granularity=granularity,
			theta=theta,
			h=h,
			g=consumptionArray,
			t=t,
			L=L,
			gamma=gamma
		)
		theta = 0
		threshold = 0
		for w in range(len(h)):
			threshold += h[w]
			theta+=granularity
			if threshold>=L*gamma:
				break
		theta=min(theta,K-1)
		endTime = time.time()
		averageRunTime += (endTime-startTime)
	averageRunTime /= T
	return accumulatedReward, averageRunTime

# OWA for trace driven
def OLSTrace(
		T: int,
		L: int,
		K: int,
		gamma: float,
		consumptionArray: np.ndarray, #L*W
		consumptionOracle: np.ndarray, #L*T
		valueArray: np.ndarray, #L*T
		doNothingValue: np.ndarray,	#L*T, need to use t-1
		granularity: float
) -> [float, float] :
	theta = 0
	W = 0
	h = np.array([0 for w in range(int(1/granularity)+1)])
	accumulatedReward = 0
	averageRunTime = 0
	lastDecision = False
	lastLevel = 0
	for t in range(T):
		startTime = time.time()
		level = L
		if t==0:
			process = True
			dice = random.random()
			level = math.floor(dice/gamma)
			if level>L-1:
				process = False
		else:
			process = False
			if W <= theta and (K-W)>=1:
				process = True
				dice = random.random()
				level = min(math.floor(dice/(1/L)),L-1)

		if process:
			e = consumptionOracle[level,t]
			W = W+e
			accumulatedReward+=valueArray[level,t]
		elif lastDecision:
			accumulatedReward += doNothingValue[lastLevel, t-1]

		h = update_hListTrace(
			granularity=granularity,
			theta=theta,
			h=h,
			g=consumptionArray,
			t=t,
			L=L,
			gamma=gamma
		)
		theta = 0
		threshold = 0
		for w in range(len(h)):
			threshold += h[w]
			theta+=granularity
			if threshold>=L*gamma:
				# theta = w*granularity
				break
		theta=min(theta,K-1)
		endTime = time.time()
		averageRunTime += (endTime-startTime)
		lastDecision = process
		lastLevel = level
	averageRunTime /= T
	return accumulatedReward, averageRunTime

def update_hList(
		granularity: float,
		theta: float,
		h: np.ndarray,
		g: np.ndarray,
		t: int,
		L: int,

		gamma: float
) -> np.ndarray:
	gBar = g[0,t]
	for l in range(1,L):
		gBar+=g[l,t]
	gBar = gBar/L
	if t == 0:
		gPlusList = np.array([1-gamma*L]+[0 for i in range(len(g[0,t])-1)])
		return np.array((gBar+gPlusList*gamma*L).tolist())
	else:
		hNew = []

		appro_theta = int(theta/granularity)
		if appro_theta < len(h)-1:
			hBar = np.concatenate((np.ones(appro_theta+1), np.zeros(len(h.tolist())-(appro_theta+1))))*h
		else:
			hBar = h
		term1 = np.convolve(hBar,gBar, mode='full')
		hNew = term1+np.concatenate((h-hBar,np.zeros(len(term1)-len(hBar))))
		if np.sum(hNew) > 0:
			hNew /= np.sum(hNew)
		return np.array(hNew)

def update_hListTrace(
		granularity: float,
		theta: float,
		h: np.ndarray,
		g: np.ndarray,
		t: int,
		L: int,

		gamma: float
) -> np.ndarray:
	gBar = g[0]
	for l in range(1,L):
		gBar+=g[l]
	gBar = gBar/L
	if t == 0:
		gPlusList = np.array([1-gamma*L]+[0 for i in range(len(g[0])-1)])
		return np.array((gBar+gPlusList*gamma*L).tolist())
	else:
		hNew = []

		appro_theta = int(theta/granularity)
		if appro_theta < len(h)-1:
			hBar = np.concatenate((np.ones(appro_theta+1), np.zeros(len(h.tolist())-(appro_theta+1))))*h
		else:
			hBar = h
		term1 = np.convolve(hBar,gBar, mode='full')
		hNew = term1+np.concatenate((h-hBar,np.zeros(len(term1)-len(hBar))))
		if np.sum(hNew) > 0:
			hNew /= np.sum(hNew)
		return np.array(hNew)

def sample_eList(
		L: int,
		consumptionArray: np.ndarray,
		t: int,
		l: int
) -> float:
	e = 0
	dice = random.random()
	if dice>=np.sum(consumptionArray[l][t]):
		e=1
	else:
		for w in range(len(consumptionArray[l][t])):
			if dice<=consumptionArray[l][t][w]:
				e = w*(1/(len(consumptionArray[l][t])-1))
				break
			else:
				dice = dice - consumptionArray[l][t][w]
	return e

def generateConsumptionArrayBeta(
		T: int,
		L: int,
		KList: np.ndarray,
		granularity: float,
) -> np.ndarray:
	averageConsumptionRaw = [[np.random.random() for _ in range(T)] for _ in range(L)]
	total = [sum(averageConsumptionRaw[l]) for l in range(L)]
	averageConsumption = [
		[averageConsumptionRaw[l][t] * KList[l] / total[l] for t in range(T)] for l in range(L)
	]

	PDFLength = int(1 / granularity)
	consumptionPDF = [[] for l in range(L)]
	pdfScale = np.arange(0, 1 + granularity, granularity)

	for l in range(L):
		for t in range(T):
			PrList = np.zeros(round(1/granularity) +1)
			if averageConsumption[l][t]>0.5:
				PrList[round(1/granularity)] = (averageConsumption[l][t]-0.5)/0.5
				PrList[round(0.5/granularity)] = 1-PrList[round(1/granularity)]
			elif averageConsumption[l][t]>=0.1:
				PrList[round(0.5 / granularity)] = (averageConsumption[l][t]-0.1)/0.4
				PrList[round(0.1 / granularity)] = 1-PrList[round(0.5 / granularity)]
			else:
				PrList[0]=1

			PrList /= np.sum(PrList)
			error = 1
			consumptionPDF[l].append(PrList.tolist())

	return np.array(consumptionPDF)

def generateValueArray(
		L: int,
		T: int,
		maxVList: np.ndarray,
		minVList: np.ndarray,
		granularity: float
) -> np.ndarray:
	valueArray = []
	for l in range(L):
		v = np.zeros(T)
		valueCandidates = np.arange(maxVList[l], minVList[l] + granularity, granularity).tolist()
		for t in range(T):
			v[t]=random.uniform(maxVList[l], minVList[l]+granularity)
		valueArray.append(v)
	return np.array(valueArray)